Attribute VB_Name = "WPDatumAndRePosition"
Option Explicit

Sub AddDatumLines()
    
    Dim pdApp As ProDESKTOP
    Set pdApp = CreateObject("ProDESKTOP.Application")
    
    Dim api As helm
    Set api = pdApp.TakeHelm
    
    Dim doc As PartDocument
    Set doc = pdApp.GetActiveDoc
    
    Dim des As aDesign
    Set des = doc.GetDesign
    
    Dim wp As aWorkplane
    Set wp = doc.GetActiveWorkplane
    
    Dim sk As aSketch
    Set sk = doc.GetActiveSketch
    
    Dim zLn1 As zCurve, zLn2 As zCurve ', zLn3 As zCurve
    Dim vec As zVector
    Dim localX As zDirection, localY As zDirection
    
    Set vec = wp.GetLocalOrigin
    Set localX = wp.GetLocalX
    Set localY = wp.GetLocalY
    
    Set zLn1 = pdApp.GetClass("BasicStraight").CreateBasicStraightLinDir(vec, localX, 0.05)
    Set zLn2 = pdApp.GetClass("BasicStraight").CreateBasicStraightLinDir(vec, localY, 0.05)
    
    Dim xLine As aLine, yLine As aLine ', circ As aLine
    Set xLine = sk.CreateLine(zLn1)
    Set yLine = sk.CreateLine(zLn2)
    
    Dim normal As zDirection
    Set normal = localX.Cross(localY).GetDirection
    
    'Set zLn3 = pdApp.GetClass("BasicCircle").CreateBasicCircle(vec, normal, 0.025)
    'Set circ = sk.CreateLine(zLn3)
    
    api.CommitCalls LoadResString(163), False
    
    Dim i As Integer, tempLine As aLine, lineSet As ObjectSet
    Dim fxLine As zFixedLine, con1 As aConstraint, con2 As aConstraint ', con3 As aConstraint
    
    Set lineSet = pdApp.GetClass("ObjectSet").CreateAObjectSet()
    
    xLine.SetConstruction True
    yLine.SetConstruction True
    'circ.SetConstruction True
    
    Set fxLine = pdApp.GetClass("FixedLine").CreateFixedLine(xLine)
    Set con1 = wp.CreateConstraint(fxLine)
    Set fxLine = pdApp.GetClass("FixedLine").CreateFixedLine(yLine)
    Set con2 = wp.CreateConstraint(fxLine)
    'Set fxLine = pdApp.GetClass("FixedLine").CreateFixedLine(circ)
    'Set con3 = wp.CreateConstraint(fxLine)
    
    lineSet.AddMember xLine
    lineSet.AddMember yLine
    'lineSet.AddMember circ

    wp.AutoConstrain lineSet
    
    api.CommitCalls LoadResString(163), False
    
End Sub

Public Sub RePositionWorkAxesToGlobalOrigin()
    
    Dim app As ProDESKTOP
    Set app = CreateObject("ProDESKTOP.Application")
    
    Dim api As helm
    Set api = app.TakeHelm
    
    Dim doc As PartDocument
    Set doc = app.GetActiveDoc
    
    Dim design As aDesign
    Set design = doc.GetDesign
    
    Dim vectorCls As VectorClass
    Dim directionCls As DirectionClass
    
    Set vectorCls = app.GetClass("Vector")
    Set directionCls = app.GetClass("Direction")
    
    On Error Resume Next
    
    Dim wp As aWorkplane
    Set wp = doc.LookupWorkplane(LoadResString(164))
    
    If wp Is Nothing Then
        MsgBox LoadResString(167) & LoadResString(164) & LoadResString(168), vbExclamation, LoadResString(169)
    Else
        wp.SetLocalOrigin vectorCls.CreateVector(0#, 0#, 0#)
        wp.SetLocalAxes directionCls.CreateDirection(1#, 0#, 0#), directionCls.CreateDirection(0#, 1#, 0#)
    End If
    
    Set wp = Nothing
    Set wp = doc.LookupWorkplane(LoadResString(165))
    If wp Is Nothing Then
        MsgBox LoadResString(167) & LoadResString(165) & LoadResString(168), vbExclamation, LoadResString(169)
    Else
        wp.SetLocalOrigin vectorCls.CreateVector(0#, 0#, 0#)
        wp.SetLocalAxes directionCls.CreateDirection(1#, 0#, 0#), directionCls.CreateDirection(0#, 0#, 1#)
    End If
   
    Set wp = Nothing
    Set wp = doc.LookupWorkplane("lateral")
    If wp Is Nothing Then
        MsgBox LoadResString(167) & LoadResString(166) & LoadResString(168), vbExclamation, LoadResString(169)
    Else
        wp.SetLocalOrigin vectorCls.CreateVector(0#, 0#, 0#)
        wp.SetLocalAxes directionCls.CreateDirection(0#, 1#, 0#), directionCls.CreateDirection(0#, 0#, 1#)
    End If
    
    api.CommitCalls LoadResString(170), False
    
End Sub

